<?php

namespace Comitium5\MailingBundle\Command;

use Comitium5\MailingBundle\Services\Reader\AbstractImap;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class PopulateBouncerListCommand
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Command
 */
class PopulateBouncerListCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('comitium5_mailing:bouncer:populate')
            ->setDescription('Fetch all bouncer emails and populate database bouncer list entities')
            ->addOption("criteria", "cri", InputOption::VALUE_OPTIONAL, "Fetching emails criteria. UNSEEN, ALL ...", "UNSEEN")
        ;
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $container = $this->getContainer();

        $bouncer = $container->get("comitium5_mailing.bouncer.doctrine_persistence");
        $reader  = $bouncer->getMailReader();

        if ($reader instanceof AbstractImap) {
            $reader->setCriteria($input->getOption("criteria"));
        }

        $bouncerListNumber = $bouncer->work();

        $output->writeln("Done! Has been created {$bouncerListNumber} bouncer list", OutputInterface::VERBOSITY_VERBOSE);
    }
}