<?php

namespace Comitium5\MailingBundle\Services\Builder;

use Comitium5\MailingBundle\Model\MailingList\MailingListInterface;
use Comitium5\MailingBundle\Services\Parser\CampaignContentParser;

/**
 * Class CampaignMessageBuilder
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Builder
 */
class CampaignMessageBuilder
{
    const HEADER_CAMPAIGN = "CS_CAMPAIGN_ID";
    const HEADER_EMAIL    = "CS_EMAIL";

    /**
     * @var CampaignContentParser
     */
    protected $parser;

    /**
     * CampaignMessageBuilder constructor.
     * @param CampaignContentParser $parser
     */
    public function __construct(CampaignContentParser $parser)
    {
        $this->parser = $parser;
    }

    /**
     * @return CampaignContentParser
     */
    public function getParser()
    {
        return $this->parser;
    }

    /**
     * @param CampaignContentParser $parser
     * @return $this
     */
    public function setParser(CampaignContentParser $parser)
    {
        $this->parser = $parser;

        return $this;
    }

    /**
     * @param MailingListInterface $mailingList
     * @return \Comitium5\MailingBundle\Services\MessageInterface
     */
    public function build(MailingListInterface $mailingList)
    {
        $message = $mailingList
            ->getCampaign()
            ->createMessage()
        ;

        $body = $mailingList
            ->getCampaign()
            ->getContent()
        ;

        $body = str_replace(
            array_keys($mailingList->getReplacements()),
            array_values($mailingList->getReplacements()),
            $body
        );

        //Build stats links
        $body = $this
            ->parser
            ->parse($mailingList, $body);

        $message->setBody($body);
        $message->setTo(trim($mailingList->getEmail()));

        $headers = $message->getHeaders();
        $headers->addTextHeader(self::HEADER_CAMPAIGN, $mailingList->getCampaign()->getId());
        $headers->addTextHeader(self::HEADER_EMAIL, $mailingList->getEmail());

        return $message;
    }
}