<?php

namespace Comitium5\MailingBundle\Model\Campaign;

use Comitium5\MailingBundle\Model\Core\DateTimeInterface;
use Comitium5\MailingBundle\Model\Core\IdentifiableInterface;
use Comitium5\MailingBundle\Model\Core\PeriodDateTimeInterface;
use Comitium5\MailingBundle\Services\MessageInterface;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Interface CampaignInterface
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Model
 */
interface CampaignInterface extends
    IdentifiableInterface,
    DateTimeInterface,
    PeriodDateTimeInterface
{
    /**
     * string
     */
    const STATE_DRAFT = "draft";

    /**
     * string
     */
    const STATE_READY = "ready";

    /**
     * string
     */
    const STATE_SENDING = "sending";

    /**
     * string
     */
    const STATE_SENT = "sent";

    /**
     * string
     */
    const STATE_PAUSE = "pause";

    /**
     * @return string
     */
    public function getName();

    /**
     * @param $name
     * @return mixed
     */
    public function setName($name);

    /**
     * @return string
     */
    public function getTestAbIdentifier();

    /**
     * @param $subject
     * @return CampaignInterface
     */
    public function setSubject($subject);

    /**
     * @return string
     */
    public function getSubject();

    /**
     * @param $fromEmail
     * @return CampaignInterface
     */
    public function setFromEmail($fromEmail);

    /**
     * @return string
     */
    public function getFromEmail();

    /**
     * @param $fromName
     * @return CampaignInterface
     */
    public function setFromName($fromName);

    /**
     * @return string
     */
    public function getFromName();

    /**
     * @param $content
     * @return CampaignInterface
     */
    public function setContent($content);

    /**
     * @return string
     */
    public function getContent();

    /**
     * @param $extraData
     * @return CampaignInterface
     */
    public function setExtraData($extraData);

    /**
     * @return string
     */
    public function getExtraData();

    /**
     * @param $extraGrouping
     * @return CampaignInterface
     */
    public function setExtraGrouping($extraGrouping);

    /**
     * @return string
     */
    public function getExtraGrouping();

    /**
     * @param CampaignStateValue $state
     * @return CampaignInterface
     */
    public function setState(CampaignStateValue $state);

    /**
     * @return mixed
     */
    public function getState();

    /**
     * @return ArrayCollection
     */
    public function getMailingLists();

    /**
     * @param string $email
     * @param array $replacements
     * @return mixed
     */
    public function addMailingList($email, array $replacements);

    /**
     * @param $email
     * @return mixed
     */
    public function removeMailingList($email);

    /**
     * @param $instancesNumber
     * @param $name
     * @param $subject
     * @param $from
     * @return array
     */
    public static function createTestAbInstances($instancesNumber, $name, $subject, $from, $content);

    /**
     * @return MessageInterface
     */
    public function createMessage();

    /**
     * @return MessageInterface
     */
    public function getMessage();

    /**
     * @param MessageInterface $message
     * @return mixed
     */
    public function setMessage(MessageInterface $message);

    /**
     * @param $emailsSent
     * @return mixed
     */
    public function setEmailsSent($emailsSent);

    /**
     * @return mixed
     */
    public function getEmailsSent();

    /**
     * @param $returnPath
     * @return string
     */
    public function setReturnPath($returnPath);

    /**
     * @return string
     */
    public function getReturnPath();

    /**
     * @return CampaignInterface
     */
    public function duplicate();

    /**
     * @param $abIdentifier
     * @return mixed
     */
    public function setAbIdentifier($abIdentifier);
}
