<?php

namespace Comitium5\MailingBundle\Tests\Parser;

use Comitium5\MailingBundle\Services\Parser\BouncerParser;
use Comitium5\MailingBundle\Services\Reader\ImapReader;
use PHPUnit\Framework\TestCase;

/**
 * Class BouncerParserTest
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Tests\Parser
 */
class BouncerParserTest extends TestCase
{
    /**
     * @expectedException \Exception
     */
    public function testParseException()
    {
        $parser = new BouncerParser();
        $parser->parse("foo");
    }

    public function testParse()
    {
        $reader = $this
            ->getMockBuilder(ImapReader::class)
            ->disableOriginalConstructor()
            ->getMock();

        $bodies = array(
            "Foo bouncer email",
            "The error that the other server returned was:
             550-5.1.1 The email account that you tried to reach does not exist. Please try
             550-5.1.1 double-checking the recipient's email address for typos or
             550-5.1.1 unnecessary spaces. Learn more at
             550 5.1.1  https://support.google.com/mail/?p=NoSuchUser r2si23129710wjf.60 - gsmtp",
            "The error that the other server returned was:
             550-5.1.1 The email account that you tried to reach does not exist. Please try
             550-5.1.1 double-checking the recipient's email address for typos or
             550-5.1.1 unnecessary spaces. Learn more at
             550 5.1.1  https://support.google.com/mail/?p=NoSuchUser r2si23129710wjf.60 - gsmtp
             CS_EMAIL: foo@bar.com
             CS_CAMPAIGN_ID: 580f8b4368568
             X-Gm-Message-State: ABUngveLJgLpSLPcBDImiCY5WxR/iNnWG58muJX8d5U0m+Tt6IXx6XcKavy4x/SqOp8BQA==",
        );

        $parsedDataExpected = array(
            array(
                "campaignId" => null,
                "email" => null,
                "errorCode" => null,
                "errorMessage" => "No reason found",
            ),
            array(
                "campaignId" => null,
                "email" => null,
                "errorCode" => 550,
                "errorMessage" => "User’s mailbox was unavailable (such as not found)",
            ),
            array(
                "campaignId" => "580f8b4368568",
                "email" => "foo@bar.com",
                "errorCode" => 550,
                "errorMessage" => "User’s mailbox was unavailable (such as not found)",
            ),
        );

        $reader
            ->method("getBodies")
            ->will($this->returnValue($bodies));

        $parser = new BouncerParser();

        $parsedData = $parser->parse($reader);

        $this->assertEquals($parsedData, $parsedDataExpected);
    }
}