<?php

namespace Comitium5\MailingBundle\Services\Parser;

use Comitium5\MailingBundle\Repository\AbstractRepository;
use Comitium5\MailingBundle\Services\Builder\CampaignMessageBuilder;
use Comitium5\MailingBundle\Services\Reader\MailReaderInterface;

/**
 * Class BouncerParser
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Bouncer
 */
class BouncerParser implements ParserInterface
{
    /**
     * @param $data
     * @return array
     * @throws \Exception
     */
    public function parse($data)
    {
        if (!$data instanceof MailReaderInterface) {
            throw new \Exception("Data must be an instance of MailReaderInterface");
        }

        $parsedData = array();

        foreach ($data->getBodies() as $body) {

            $campaignId = null;
            $email = null;
            $errorCode = null;
            $errorMessage = null;

            BounceCode::getCode($body, $errorCode, $errorMessage);

            preg_match("/".CampaignMessageBuilder::HEADER_CAMPAIGN.":(.+)/", $body, $matches);

            if (!empty($matches[1])) {
                $campaignId = $matches[1];
            }

            preg_match("/".CampaignMessageBuilder::HEADER_EMAIL.":(.+)/", $body, $matches);

            if (!empty($matches[1])) {
                $email = $matches[1];
            }

            $parsedData[] = array(
                "campaignId" => trim($campaignId),
                "email"  => trim($email),
                "errorCode" => $errorCode,
                "errorMessage" => $errorMessage,
            );
        }

        return $parsedData;
    }
}