<?php

namespace Comitium5\MailingBundle\Model\Campaign;

use Comitium5\MailingBundle\Model\Core\DateTimeInterface;
use Comitium5\MailingBundle\Model\Core\EmailCampaignInterface;
use Comitium5\MailingBundle\Model\Core\IdentifiableInterface;

/**
 * Interface CampaignStats
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Model\Campaign
 */
interface CampaignStatsInterface extends
    IdentifiableInterface,
    EmailCampaignInterface,
    DateTimeInterface
{
    /**
     * string
     */
    const CLICK = "click";

    /**
     * string
     */
    const OPEN = "open";

    /**
     * string
     */
    const BOUNCED = "bounced";

    /**
     * @param CampaignStatValue $campaignStatValue
     * @return mixed
     */
    public function compute(CampaignStatValue $campaignStatValue);

    /**
     * @param $extraData
     * @return mixed
     */
    public function setExtraData($extraData);

    /**
     * @return mixed
     */
    public function getExtraData();
}