<?php

namespace Comitium5\MailingBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('comitium5_mailing');

        $validReaders = array(
            "comitium5_mailing.reader.imap",
            "comitium5_mailing.reader.pop3"
        );

        $rootNode
            ->children()
                ->scalarNode("smtp_host")
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode("smtp_port")
                    ->validate()
                        ->ifTrue(function($value){
                            return !is_numeric($value);
                        })
                        ->thenInvalid("Value must be numeric")
                    ->end()
                    ->isRequired()
                    ->defaultValue("25")
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode("smtp_user")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("smtp_password")
                    ->isRequired()
                    ->defaultNull()
                ->end()
                ->scalarNode("smtp_security")
                    ->validate()
                        ->ifNotInArray(array(null,"ssl"))
                        ->thenInvalid("Value must be null or ssl")
                    ->end()
                    ->defaultNull()
                ->end()
                ->scalarNode("smtp_return_path")
                    ->validate()
                        ->ifTrue(function($value){
                            return filter_var($value, FILTER_VALIDATE_EMAIL) === false;
                        })
                        ->thenInvalid("Value must be an email valid address")
                    ->end()
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode("imap_connection_string")
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode("imap_user")
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode("imap_password")
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode("build_stats_links")
                    ->defaultFalse()
                ->end()
                ;

        return $treeBuilder;
    }
}
