<?php

namespace Comitium5\MailingBundle\Services\Sender;

use Comitium5\MailingBundle\Services\AuthenticatorMailTrait;
use Swift_Mailer;
use Swift_Mime_Message;

/**
 * Class SmtpSender
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Sender
 */
class SmtpSender extends Swift_Mailer implements MailSenderInterface
{
    use AuthenticatorMailTrait;

    /**
     * SmtpSender constructor.
     */
    public function __construct(TransportInterface $transport)
    {
        parent::__construct($transport->getTransport());
    }

    /**
     * @param Swift_Mime_Message $message
     * @param null $failedRecipients
     * @return int
     */
    public function send(Swift_Mime_Message $message, &$failedRecipients = null)
    {
        try {
            $this->ensureConnectionIsClosed();

            return parent::send($message, $failedRecipients);
        } catch (\Exception $e) {
            sleep(4);

            $this->ensureConnectionIsClosed();

            return parent::send($message, $failedRecipients);
        }
    }

    private function ensureConnectionIsClosed(): void
    {
        if ($this->getTransport()->isStarted()) {
            $this->getTransport()->stop();
        }
    }
}