<?php

namespace Comitium5\MailingBundle\Services\Response;

use Comitium5\MailingBundle\Model\MailingList\MailingListInterface;

/**
 * Class MailingListResponse
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Response
 */
class MailingListResponse
{
    /**
     * @var MailingListInterface
     */
    protected $mailingList;

    /**
     * @var mixed
     */
    protected $result;

    /**
     * @var array
     */
    protected $failedRecipients;

    /**
     * MailingListResponse constructor.
     * @param MailingListInterface $mailingList
     * @param $result
     * @param array $failedRecipients
     */
    public function __construct(
        MailingListInterface $mailingList,
        $result,
        array $failedRecipients
    ) {
        $this->mailingList = $mailingList;
        $this->result = $result;
        $this->failedRecipients = $failedRecipients;
    }

    /**
     * @return MailingListInterface
     */
    public function getMailingList()
    {
        return $this->mailingList;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return array
     */
    public function getFailedRecipients()
    {
        return $this->failedRecipients;
    }
}