<?php

namespace Comitium5\MailingBundle\Services\Builder;

use Comitium5\MailingBundle\Services\Message;

/**
 * Class MessageBuilder
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\MailingBundle\Services\Builder
 */
class MessageBuilder
{
    public function build(
        string $from,
        array $recipients,
        string $subject,
        string $body
    ): Message {
        $message = new Message($subject, $body, "text/html");

        $message
            ->setFrom($from)
            ->setTo($recipients);

        return $message;
    }
}
