var publicUrlHandler = (function () {
    return {
        handleTooltipCopy: function (element, loadingClass) {
            element      = typeof element === "undefined" ? $("[data-copy-url]") : element;
            loadingClass = typeof loadingClass === "undefined" ? "loading" : loadingClass;

            element.on("click", function () {
                var $this = $(this);

                RoutingGenerator.generate($this.data("entity-id"), $this.data("entity-class"), $this.data("entity-locale"), {
                    beforeCallBack: function () {
                        $this.addClass(loadingClass);
                    },
                    successCallback: function (response) {
                        var clipBoardCopyHelper = new ClipboardCopyHelper();

                        clipBoardCopyHelper.bindTooltipAction($this, response.link);
                    },
                    completeCallBack: function () {
                        $this.removeClass(loadingClass);
                    }
                });
            });
        },
        handleOpenPublicUrl: function (element, loadingClass) {
            element      = typeof element === "undefined" ? $("[data-public-url]") : element;
            loadingClass = typeof loadingClass === "undefined" ? "loading" : loadingClass;

            element.on("click", function () {
                var $this = $(this);

                RoutingGenerator.generate($this.data("entity-id"), $this.data("entity-class"), $this.data("entity-locale"), {
                    beforeCallBack: function () {
                        $this.addClass(loadingClass);
                    },
                    successCallback: function (response) {
                        window.open(response.link, "_blank");
                    },
                    completeCallBack: function () {
                        $this.removeClass(loadingClass);
                    }
                });
            });
        }
    };
})();