var Libraries = (function () {

    function LibrariesList(selector){

        this.toasterShowing = false;

        this.tableSelector = selector;

        this.bindFunctions();
    }

    LibrariesList.prototype = {
        toggleEnabled: function(data) {
            $.ajax({
                url: Routing.generate('admin_library_js_set_state'),
                data: data,
                method: 'POST',
                success: function(response) {
                    if (response.updated) {
                        var message = '';

                        if (data.state == 'enabled') {
                                message = 'admin_library_js.messages.success.enabled';
                        } else {
                                message = 'admin_library_js.messages.success.disabled';
                        }

                        $('[data-id="'+data.id+'"]')
                            .data('status', data.state)
                            .find('i')
                            .removeClass('fa-dot-circle-o fa-circle-o')
                            .addClass((data.state == 'enabled') ? 'fa-dot-circle-o' : 'fa-circle-o');

                        showToastrNotification('success',Translator.trans(message));
                    }
                },
                error: function() {
                    showToastrNotification('error',Translator.trans('admin_library_js.index.messages.error.enabled_disabled'));
                }
            });
        },
        bindFunctions: function() {

            var _this = this;

            $(this.tableSelector).on('click','[data-status]', function() {

                var data = {};

                data.id = $(this).data('id');
                data.state = ($(this).data('status') == 'enabled') ? 'disabled' : 'enabled';

                _this.toggleEnabled(data);
            });
        },
        initializeLibraries: function() {
            this.bindFunctions();
        }
    };

    function LibrariesForm(formName, selector, options){
        this.form = $('form[name="'+formName+'"]');
        this.dropzone = new DropzoneCS(selector, options);
        this.bindFunctions();
    }

    LibrariesForm.prototype = {
        bindFunctions: function() {
            var _this = this;

            var externalCheck = $('#admin_library_js_external');

            _this.initDropZone();

            externalCheck
                .on('switchChange.bootstrapSwitch', function(event, state) {
                    _this.changeSourceField(state);
                })
            ;

            _this.changeVisibleField(externalCheck.is(':checked'));

        },
        setPath: function(path) {
            $('#admin_library_js_source').val(path);
        },
        removeFile: function(path){
            $.post(Routing.generate('admin_library_js_remove_file'),{source:path});
        },
        initDropZone: function(){
            var _this = this;

            $.each(_this.dropzone.dropzones, function(k,el){
                var _dropzone = el[0].dropzone;

                var fileField = $('#admin_library_js_source');

                if(fileField.val()){
                    var file = { name: fileField.data('name'), size: fileField.data('size') };

                    _dropzone.options.addedfile.call(_dropzone, file);
                }

                _dropzone.on('success', function(file, response) {
                    if(fileField.val()){
                        _this.removeFile(fileField.val())
                    }
                   _this.setPath(response);
                    $(".dz-preview.dz-file-preview").not('.dz-success').remove();
                });
            });
        },
        changeSourceField: function(external){

            this.changeVisibleField(external);

            if(!external){
                $("#admin_library_js_url").val(null);
                $.each(this.dropzone.dropzones, function(k,el){
                    var _dropzone = el[0].dropzone;

                    _dropzone.removeAllFiles();
                    $(".dz-preview.dz-file-preview").remove();
                });
            }
        },
        changeVisibleField: function(external){
            var urlField = $("#admin_library_js_url").closest('.form-group');
            var sourceField = $(".cs_dropzone.dropzone.dz-clickable").closest('.form-group');

            var showField = (external) ? 'hide' : 'show';
            var showUrl = (external) ? 'show' : 'hide';

            sourceField[showField]();
            urlField[showUrl]();
        }
    };

    return {
        initList: function(selector) {
            var _librariesList = new LibrariesList(selector);

            Pagination.onChange.add(function() {
                _librariesList.initializeLibraries();
            });
        },
        initForm: function(formName, selector, options){
            new LibrariesForm(formName, selector, options);
        }
    }
})();
