var Config = (function() {

    var init = function() {

        Calendar.initEditable('.date-picker');

        $('.form-horizontal').submit(function(e){
            e.preventDefault();

            var values = {};

            $.each($(this).serializeArray(), function(i, field) {
                values[field.name] = field.value;
            });

            var checkboxes = $(this).find('input[type="checkbox"]');

            $.each( checkboxes, function( key, value ) {
                if (value.checked === false) {
                    value.value = 0;
                } else {
                    value.value = 1;
                }

                values[value.name] = value.value;
            });

            updateParams(values);
        });
    };

    var updateParams = function(groupConfig) {

        $.ajax({
            url: Routing.generate('cs_core_config_update'),
            data: {data:groupConfig},
            method: 'POST',
            success: function(response) {
                showToastrNotification('success',response.message);
            }
        });

    };

    return {
        init: function() {
            init();
        }
    };
})();
