var LayoutBreakpoint = Class.extend({
	init: function(data)
	{
		this.id = 0;
		this.type = null;
		this.columns = 0;
		this.visibility = true;

		if (typeof(data) != "undefined") {
			this.load(data);
		}
	},
	load: function(data)
	{
		try {
			if (typeof(data) == "string") {
				data = jQuery.parseJSON(data);
			}
			this.id = data.id;
			this.columns = data.columns;
			this.visibility = (data.enabled == 1);
			if (data.breakpoint) {
				this.type = data.breakpoint.type;
			} else if(data.type) {
				this.type = data.type;
			}
		} catch(error) {}
	},
	columnsClass: function()
	{
		return Breakpoint.PREFIX_COLUMNS_CLASS+'-'+this.type+'-'+this.columns;
	},
	hiddenClass: function()
	{
		return Breakpoint.PREFIX_HIDDEN_CLASS+'-'+this.type;
	},
	addClass: function(item)
	{
		item.addClass(this.columnsClass());
		if (this.visibility) {
			item.removeClass(this.hiddenClass());
		} else {
			item.addClass(this.hiddenClass());
		}
	},
	changeVisibility: function(item)
	{
		/*if (this.visibility) {
			item.removeClass(this.columnsClass());
		} else {
			item.removeClass(this.hiddenClass());
		}*/
		this.visibility = !this.visibility;
		this.addClass(item);
	},
	export: function()
	{
		var item = new Object();

		item.id = this.id;
		item.breakpoint = this.type;
		item.columns = this.columns;
		item.enabled = this.visibility;

		return item;
	}
});
