var Calendar = function() {

    var editableInline = function(options) {

        var defaultOptions = {
            selector: "#editable_publish_date",
            format: "'yyyy-mm-dd hh:ii'",
            viewFormat: "'dd/mm/yyyy hh:ii'",
            mode: "inline",
            locale: document.documentElement.lang,
            todayBtn: "linked",
            weekStart: 1
        };

        $.extend(defaultOptions, options);

        $(defaultOptions.selector).editable({
            format: defaultOptions.format,
            viewformat: defaultOptions.viewFormat,
            mode: defaultOptions.mode,
            validate: function (v) {
                var date = moment(v).format('YYYY-MM-DD HH:mm:ss');
                $('#'+$(this).data('for')).val(date);
            },
            datetimepicker: {
                rtl : Metronic.isRTL(),
                format: defaultOptions.format,
                todayBtn: defaultOptions.todayBtn,
                weekStart: defaultOptions.weekStart,
                language: defaultOptions.locale
            }
        });
    };

    var initTimePicker = function(options) {

        var defaultOptions = {
            selector: ".timepicker"
        };

        $.extend(defaultOptions, options);

        $(defaultOptions.selector).each(function(){

            var _this = $(this);

            _this.timepicker(options);

            _this.parent(".timepicker").find("button").each(function(){
                if ($(this).hasClass("date-set")) {
                    $(this).on('click', function(e){
                        e.preventDefault();
                        _this.timepicker('showWidget');
                    });
                } else if ($(this).hasClass("date-reset")) {
                    $(this).on('click', function(e){
                        e.preventDefault();
                        _this.val("");
                    });
                }
            });
        });
    };

    var initDateTimePicker = function(options) {
        var lang = $(this).data("lang")||$("html").attr("lang");
        var defaultOptions = {
            selector: "",
            parentSelector: "",
            isRTL: Metronic.isRTL(),
            format: "dd/mm/yyyy - hh:ii",
            autoclose: true,
            todayBtn: true,
            pickerPosition: "bottom-left",
            minuteStep: 5,
            language: lang
        };

        $.extend(defaultOptions, options);

        $(defaultOptions.selector).each(function(){
            $(this).datetimepicker(defaultOptions);
        });
    };

    return {
        initEditable: function(options) {
            editableInline(options);
        },
        initTimePicker: function(options) {
            initTimePicker(options);
        },
        initDateTimePicker: function(options) {
            initDateTimePicker(options);
        }
    };
}();
