function TemplateForm() {
}

TemplateForm.prototype.init = function () {
    this.initRadioButtonsAction();
    this.initAceEditor();
    this.initDeleteModal();
    this.initSelect2();
};

TemplateForm.prototype.initRadioButtonsAction = function () {
    if ($("input[name=parentRadio]").length > 0) {
        TemplateForm.prototype.addRadioLoadEvent();
        TemplateForm.prototype.addRadioChangeEvent();
    }
};

TemplateForm.prototype.initAceEditor = function () {
    var frontAceEditor = new FrontAceEditor();
    frontAceEditor.init();
};

TemplateForm.prototype.initDeleteModal = function () {
    var singleDeleteAction = new DeleteContentActivity();

    singleDeleteAction
        .setSelector('[data-toggle="modal"][data-behaviour="delete"]')
        .init();
};

TemplateForm.prototype.initSelect2 = function () {
    var frontSelect2 = new FrontSelect2();

    frontSelect2.init();
    if ($("input[name=parentRadio]").length > 0 && $('input[type=radio][name=parentRadio]:checked').val() === 'existing') {
        TemplateForm.prototype.disableBreakpointSelector();
    }

    if ($("input[name=parentRadio]").length > 0 && $('input[type=radio][name=parentRadio]:checked').val() === 'none') {
        $("#admin_template_parent").prop("disabled", true);
    }
};

TemplateForm.prototype.disableBreakpointSelector = function () {
    let selectBreakpoints = $("#admin_template_breakpoints");
    selectBreakpoints.prop("disabled", true);
    $("[data-breakpoint-card-body]").hide();
    $("[data-breakpoints-block-title]").addClass("is-disabled");
    TemplateForm.prototype.showBreakpointsMessageContainer();
};

TemplateForm.prototype.enableBreakpointSelector = function () {
    let selectBreakpoints = $("#admin_template_breakpoints");
    selectBreakpoints.prop("disabled", false);
    $("[data-breakpoint-card-body]").show();
    $("[data-breakpoints-block-title]").removeClass("is-disabled");
    TemplateForm.prototype.hideBreakpointsMessageContainer();
};

TemplateForm.prototype.addRadioChangeEvent = function () {
    $('input[type=radio][name=parentRadio]').on("change", function () {
        var select = $("#admin_template_parent");
        if ($(this).val() === 'existing') {
            TemplateForm.prototype.disableBreakpointSelector();
            select.prop("disabled", false);
        }
        if ($(this).val() === 'none') {
            TemplateForm.prototype.enableBreakpointSelector();
            select.val([]);
            select.prop("disabled", true);
            select.trigger("change");
        }
    });
};

TemplateForm.prototype.addRadioLoadEvent = function () {
    $('input[type=radio][name=parentRadio]').on("load", function () {
        if ($(this).val() === 'existing') {
            TemplateForm.prototype.disableBreakpointSelector();
        }
    });
};

TemplateForm.prototype.showBreakpointsMessageContainer = function () {
    let templateName = TemplateForm.prototype.fetchSelectedParentTemplateName();
    let blockContainer = $("[data-message-container]");
    let templateNameContainer = $("[data-breakpoint-message-template]");
    templateNameContainer.text(templateName);
    TemplateForm.prototype.updateBreakpointsMessage(templateNameContainer);
    blockContainer.show();
};

TemplateForm.prototype.fetchSelectedParentTemplateName = function () {
    return $("#select2-admin_template_parent-container").text();
};

TemplateForm.prototype.updateBreakpointsMessage = function (messageContent) {
    $('#admin_template_parent').on("select2:select", function () {
        let templateName = TemplateForm.prototype.fetchSelectedParentTemplateName();
        messageContent.text(templateName);
    })
};

TemplateForm.prototype.hideBreakpointsMessageContainer = function () {
    $("[data-message-container]").hide();
};