<?php

namespace Comitium5\DesignerBundle\ValueObjects;

/**
 * Class IdentifiedValueObject
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects
 */
class IdentifiedValueObject
{
    /**
     * @var string
     */
    private $uuid;

    /**
     * IdentifiedValueObject constructor.
     *
     * @param string $uuid
     *
     * @throws \Exception
     */
    public function __construct(string $uuid)
    {
        $this->validateParameters($uuid);

        $this->uuid = $uuid;
    }

    /**
     * @param string $uuid
     *
     * @throws \Exception
     */
    protected function validateParameters(string $uuid)
    {
        if (empty($uuid)) {
            throw new \Exception("Uuid is required");
        }

        if (!is_string($uuid)) {
            throw new \Exception("Uuid must be string");
        }
    }

    /**
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }

}
