<?php

namespace Comitium5\DesignerBundle\ValueObjects;

/**
 * Class ExternalDbResultObject
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects
 */
class ExternalDbResultObject
{
    /**
     * @var array
     */
    private $results;

    /**
     * @var int
     */
    private $status;

    /**
     * ExternalDbResultObject constructor.
     *
     * @param array $results
     * @param int $status
     */
    public function __construct(array $results, int $status)
    {
        $this->results = $results;
        $this->status = $status;
    }

    /**
     * @return array
     */
    public function getResults(): array
    {
        return $this->results;
    }

    /**
     * @return int
     */
    public function getStatus(): int
    {
        return $this->status;
    }
}