<?php

namespace Comitium5\DesignerBundle\ValueObjects\Asset;

/**
 * Class UploadAssetObject
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects\Asset
 */
class UploadAssetObject
{
    /**
     * @var int
     */
    protected $id;

    /**
     * @var string
     */
    protected $path;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var int
     */
    protected $width;

    /**
     * @var int
     */
    protected $height;

    /**
     * UploadAssetObject constructor.
     *
     * @param int $id
     * @param string $path
     * @param string $title
     * @param int|null $width
     * @param int|null $height
     */
    public function __construct(int $id, string $path, string $title, ?int $width = null, ?int $height = null)
    {
        $this->id     = $id;
        $this->path   = $path;
        $this->title  = $title;
        $this->width  = $width;
        $this->height = $height;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return mixed|string
     */
    public function getDirectoryPath()
    {
        return pathinfo($this->path)["dirname"];
    }

    /**
     * @return int
     */
    public function getWidth(): ?int
    {
        return $this->width;
    }

    /**
     * @return int
     */
    public function getHeight(): ?int
    {
        return $this->height;
    }
}
