<?php

namespace Comitium5\DesignerBundle\Validator\Page;

use Comitium5\DesignerBundle\Entity\Page;
use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;
use Comitium5\DesignerBundle\Validator\EntityValidatorConstraintAbstract;
use Comitium5\DesignerBundle\Validator\EntityValidatorConstraintInterface;

/**
 * Class PageHasRelatedTemplateConstraint
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Validator\Page
 */
class PageHasRelatedTemplateConstraint extends EntityValidatorConstraintAbstract implements EntityValidatorConstraintInterface
{
    /**
     * PageHasRelatedTemplateConstraint constructor.
     */
    public function __construct()
    {
        $this->message = "common.errors.template_not_associated";
    }

    /**
     * @param Page $page
     *
     * @return bool
     */
    public function check(IdentifiableInterface $page): bool
    {
        return !empty($page->getTemplate());
    }
}
