<?php

namespace Comitium5\DesignerBundle\Validator;

/**
 * Class EntityValidatedResult
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Validator
 */
class EntityValidatedResult implements EntityValidatedResultInterface
{
    /**
     * @var EntityValidatorConstraintInterface[]
     */
    public $failedValidations;

    /**
     * EntityValidatedResult constructor.
     */
    public function __construct()
    {
        $this->failedValidations = [];
    }

    /**
     * @param EntityValidatorConstraintInterface $constraint
     *
     * @return array
     */
    public function add(EntityValidatorConstraintInterface $constraint): array
    {
        $this->failedValidations[] = $constraint;

        return $this->failedValidations;
    }

    /**
     * @return bool
     */
    public function isValidResult() : bool {
        return empty($this->failedValidations);
    }

    /**
     * @return string
     */
    public function getErrorMessage() : string {

        if (empty($this->failedValidations)) {
            return "";
        }

        return current($this->failedValidations)->getMessage();
    }
}
