<?php

namespace Comitium5\DesignerBundle\Tests\ValueObjects;

use Comitium5\DesignerBundle\Tests\AbstractTestCase;
use Comitium5\DesignerBundle\ValueObjects\PageMessageObject;

/**
 * Class PageMessageObjectTest
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\DesignerBundle\Tests\ValueObjects
 */
class PageMessageObjectTest extends AbstractTestCase
{
    /**
     * @throws \Exception
     */
    public function testValidObject()
    {
        $message = '{"data": {"attributes":{"id": 1000, "is_published": true}, "event":"foo_event" }}';

        $pageMessage = new PageMessageObject($message);

        $this->assertEquals($pageMessage->getId(), 1000);
        $this->assertTrue($pageMessage->isPublished());
        $this->assertEquals($pageMessage->getEvent(), 'foo_event');
    }

    /**
     * @throws \Exception
     */
    public function testExpectedException()
    {
        $this->expectException(\Exception::class);

        $message = '{"data": {}}';

        new PageMessageObject($message);
    }
}