<?php

namespace Comitium5\DesignerBundle\Tests\UseCase\Template;

use Comitium5\DesignerBundle\Entity\Template;
use Comitium5\DesignerBundle\Resolver\Template\TemplateTreeResolver;
use PHPUnit\Framework\TestCase;

/**
 * Class TemplateTreeResolverTest
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\DesignerBundle\Tests\UseCase\Template
 */
class TemplateTreeResolverTest extends TestCase {


    /**
     * @return array
     */
    public function setUpTemplateArray() : array
    {
        $template1 = new Template();
        $template2 = new Template();
        $template3 = new Template();
        $template4 = new Template();
        $template5 = new Template();

        $template1->setId(1);
        $template2->setId(2);
        $template3->setId(3);
        $template4->setId(4);
        $template5->setId(5);
        $template2->setParent($template1);
        $template3->setParent($template1);
        $template4->setParent($template3);

        return [
            $template1,
            $template2,
            $template3,
            $template4,
            $template5,
        ];
    }

    /**
     * @test
     */
    function treeBuilderTest() : void
    {
        $templates = $this->setUpTemplateArray();

        $templatesTree = TemplateTreeResolver::resolve($templates);

        $this->assertCount(2, $templatesTree);
        $this->assertCount(2, $templatesTree[0]->getChildren());
        $this->assertCount(0, $templatesTree[0]->getChildren()[0]->getChildren());
        $this->assertCount(1, $templatesTree[0]->getChildren()[1]->getChildren());
        $this->assertCount(0, $templatesTree[1]->getChildren());

        $this->assertEquals(1, $templatesTree[0]->getId());
        $this->assertEquals(5, $templatesTree[1]->getId());
        $this->assertEquals(2, $templatesTree[0]->getChildren()[0]->getId());
        $this->assertEquals(3, $templatesTree[0]->getChildren()[1]->getId());
        $this->assertEquals(4, $templatesTree[0]->getChildren()[1]->getChildren()[0]->getId());
    }
}