<?php

namespace Comitium5\DesignerBundle\Tests\UseCase\Page;

use Comitium5\DesignerBundle\Entity\Page;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageRepositoryInterface;
use Comitium5\DesignerBundle\Tests\AbstractTestCase;
use Comitium5\DesignerBundle\UseCase\Page\DeletePageUseCase;

/**
 * Class DeletePageUseCaseTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Tests\UseCase\Page
 */
class DeletePageUseCaseTest extends AbstractTestCase
{
    /**
     *
     */
    public function testDelete()
    {
        $pageId = 1;

        $useCase = new DeletePageUseCase($this->pageRepositoryWithPage($pageId));

        $this->assertTrue($useCase($pageId));
    }

    /**
     *
     */
    public function testDeleteWithUnExistingPage()
    {
        $useCase = new DeletePageUseCase($this->pageRepositoryWithUnExistingPage());

        $this->assertFalse($useCase(1));
    }

    /**
     * @param int $pageId
     *
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function pageRepositoryWithPage(int $pageId)
    {
        $mock = $this->createMock(PageRepositoryInterface::class);

        $page = new Page();

        $page->setOriginId($pageId);

        $mock
            ->method("getPageFromOrigin")
            ->willReturn($page);

        return $mock;
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function pageRepositoryWithUnExistingPage()
    {
        $mock = $this->createMock(PageRepositoryInterface::class);

        $mock
            ->method("getPageFromOrigin")
            ->willReturn(null);

        return $mock;
    }
}
