<?php

namespace Comitium5\DesignerBundle\Tests\UseCase\Page;

use Comitium5\DesignerBundle\Entity\Page;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PagePublisherInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageRepositoryInterface;
use Comitium5\DesignerBundle\Tests\AbstractTestCase;
use Comitium5\DesignerBundle\UseCase\Page\ChangeStatePageUseCase;

/**
 * Class ChangeStatePageUseCaseTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Tests\UseCase\Page
 */
class ChangeStatePageUseCaseTest extends AbstractTestCase
{
    /**
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function testChangeStatePublished()
    {
        $useCase = new ChangeStatePageUseCase(
            $this->pageRepository(1),
            $this->pagePublisher()
        );

        $this->assertTrue($useCase(1, ChangeStatePageUseCase::PUBLISHED));
    }

    /**
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function testChangeStateUnPublished()
    {
        $useCase = new ChangeStatePageUseCase(
            $this->pageRepository(1),
            $this->pagePublisher()
        );

        $this->assertTrue($useCase(1, ChangeStatePageUseCase::UNPUBLISHED));
    }

    /**
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function testChangeStateWithUnExistingPage()
    {
        $useCase = new ChangeStatePageUseCase(
            $this->pageRepository(1),
            $this->pagePublisher()
        );

        $this->assertFalse($useCase(2, ChangeStatePageUseCase::UNPUBLISHED));
    }

    /**
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function testChangeStateWithUnExistingState()
    {
        $useCase = new ChangeStatePageUseCase(
            $this->pageRepository(1),
            $this->pagePublisher()
        );

        $this->assertFalse($useCase(1, "foo"));
    }

    /**
     * @param int $pageId
     *
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function pageRepository(int $pageId)
    {
        $mock = $this->createMock(PageRepositoryInterface::class);

        $mock
            ->method("getPageFromOrigin")
            ->willReturnCallback(function ($id) use ($pageId) {
                if ($id === $pageId) {
                    $page = new Page();

                    $page->setOriginId($pageId);

                    return $page;
                }

                return null;
            });

        return $mock;
    }

    /**
     * @return PagePublisherInterface|\PHPUnit\Framework\MockObject\MockObject
     */
    private function pagePublisher()
    {
        $mock = $this->createMock(PagePublisherInterface::class);

        $mock->method("publish");

        $mock->method("unPublish");

        return $mock;
    }
}
