<?php

namespace Comitium5\DesignerBundle\Tests\UseCase\Asset;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\DesignerBundle\Tests\AbstractTestCase;
use Comitium5\DesignerBundle\UseCase\Asset\DeleteAssetUseCase;

/**
 * Class DeleteAssetUseCaseTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Tests\UseCase\Asset
 */
class DeleteAssetUseCaseTest extends AbstractTestCase
{
    /**
     * @throws \Exception
     */
    public function testDelete()
    {
        $useCase = new DeleteAssetUseCase($this->apiService());

        $success = $useCase(new IdentifiedValue(1));

        $this->assertTrue($success);
    }

    /**
     * @throws \Exception
     */
    public function testDeleteOnFailure()
    {
        $useCase = new DeleteAssetUseCase($this->apiServiceOnFailure());

        $success = $useCase(new IdentifiedValue(1));

        $this->assertFalse($success);
    }

    /**
     * @return AssetApiService|\PHPUnit_Framework_MockObject_MockObject
     */
    private function apiService()
    {
        $mock = $this->createMock(AssetApiService::class);

        $mock
            ->method("delete")
            ->willReturnCallback(function (IdentifiedValue $identifiedValue) {
                return [
                    "id" => $identifiedValue->getId()
                ];
            });

        return $mock;
    }

    /**
     * @return AssetApiService|\PHPUnit_Framework_MockObject_MockObject
     */
    private function apiServiceOnFailure()
    {
        $mock = $this->createMock(AssetApiService::class);

        $mock
            ->method("delete")
            ->willReturn([]);

        return $mock;
    }
}
