<?php

namespace Comitium5\DesignerBundle\Service\Pagination;

use Comitium5\DesignerBundle\Model\Interfaces\Pagination\PaginationInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Pagination\PaginatorInterface;
use Knp\Component\Pager\PaginatorInterface as KnpPaginatorInterface;

/**
 * Class KnpPaginationService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Service\Pagination
 */
class KnpPaginationService implements PaginatorInterface
{
    /**
     * @var KnpPaginatorInterface
     */
    protected $paginator;

    /**
     * KnpPaginationService constructor.
     *
     * @param $paginator
     */
    public function __construct(KnpPaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }

    /**
     * @param $target
     * @param int $page
     * @param int $limit
     * @param array $options
     *
     * @return KnpPagination|mixed
     */
    public function paginate($target, $page = 1, $limit = 10, array $options = []): PaginationInterface
    {
        return new KnpPagination(
            $this
                ->paginator
                ->paginate($target, $page, $limit, $options)
        );
    }
}
