var AutoPopulate = (function() {

    var initContentPopulationFromUrl = function() {
        $('[data-action="get"]').on("click", function(e){
            e.preventDefault();

            var input = $('[name="og-url"]');
            var type = $(this).data("type");
            var url = input.val();

            if (/^http/.test(url) === false) {
                url = "http://" + url;
            }

            $.ajax({
                url: Routing.generate("cs_core_open_graph_fetch_from_url"),
                method: "get",
                data: {
                    url: url,
                    type: type
                },
                dataType: "json",
                beforeSend: function() {
                    ComitiumUtils.showSpinner();
                },
                complete: function() {
                    ComitiumUtils.hideSpinner();
                },
                success: function(response) {
                    populateBasicInfo(
                        response.title,
                        response.description,
                        response.assetId,
                        response.match
                    );

                    showToastrNotification("success", Translator.trans("articleType.fetch_content.success"))
                },
                error: function() {
                    showToastrNotification("error", Translator.trans("articleType.fetch_content.error"))
                }
            })
        });
    };

    var populateBasicInfo = function(title, description, assetId, match) {
        var titleInput       = $('[id$="defaultLang_title"]');
        var descriptionInput = $('[data-semantical="body"]');
        var subTitleInput    = $('[data-semantical="subtitle"]');
        var assetInput       = $('.assets-widget:first');

        if (titleInput) {
            str = cutText(title, titleInput.attr("maxlength") );
            titleInput.val(str);
            titleInput.trigger("change");
        }

        var candidate = subTitleInput;

        if (match === "json") {
            if (descriptionInput.length > 0) {
                candidate = descriptionInput;
            }
        } else {
            if (candidate.length === 0 && descriptionInput.length > 0) {
                candidate = descriptionInput;
            }
        }

        if (candidate.length > 0) {
            var nodeId = candidate.attr("id");
            var isCKEditor = CKEDITOR.instances[nodeId];

            str = cutText(description, candidate.attr("maxlength") );

            if (isCKEditor) {
                CKEDITOR.instances[nodeId].setData(str);
            }

            candidate.val(str);
            candidate.trigger("change");
        }

        if (assetInput.length > 0 && assetId) {
            assetInput.find('[data-action="unselect"]').trigger("click");
            if (assetId) {
                AssetsHelper.loadById(assetInput, assetId);
            }
        }
    };

    var cutText = function(str, length)
    {
        return str.substr(0, length);
    };

    return {
        initContentPopulationFromUrl: function() {
            initContentPopulationFromUrl();
        }
    };
})();
