var SharedContent = (function() {
  var checkBoxSelector       = '[name="shared-content-sub-site"]';
  var subSiteCheckedSelector = '[name="shared-content-sub-site"]:checked';
  var modalSubmitSelector    = '[data-btn-type="save"]';

  var switchAllSubSites = function(modal, state) {
    $(checkBoxSelector, modal).each(function(){
      var value = $(this).val();
      var isChecked = $(this).is(':checked');

      if (value !== 'all') {
        if (isChecked !== state) {
          $(this).trigger('click');
        }
      }
    });
  }

  var bindEvents = function(contentId){
    var callUrl = Routing.generate('cs_cms_sharedContent_create', { id: contentId });

    $.ajax({
      url: callUrl,
      method: 'get',
      dataType: 'json',
      beforeSend: function() {
        ComitiumUtils.showSpinner();
      },
      success: function(response) {
        var modal = $(response.modal);

        modal
          .find(checkBoxSelector)
          .bootstrapSwitch()
        ;

        modal
          .find(checkBoxSelector)
          .on('switchChange.bootstrapSwitch', function(event, state){
            var isAll = $(this).val() === 'all';

            if (isAll) {
              switchAllSubSites(modal, state);
            }

            var hasChecked = $(subSiteCheckedSelector).length > 0;

            if (hasChecked) {
              modal.find(modalSubmitSelector).attr('disabled', false);
            } else {
              modal.find(modalSubmitSelector).attr('disabled', true);
            }
          });

        modal.find(modalSubmitSelector).on("click", function(){
          var selected = $(subSiteCheckedSelector);
          var subSites = [];

          selected.each(function(){
            var value = $(this).val();

            if (value !== 'all') {
              subSites.push($(this).val());
            }
          });

          if (subSites.length > 0) {
            $.ajax({
              url: callUrl,
              method: 'post',
              dataType: 'json',
              data: {
                subSites: subSites
              },
              beforeSend: function() {
                modal.modal('hide');
                modal.remove();
                ComitiumUtils.showSpinner();
              },
              success: function(response){
                response.statuses.forEach(function(data){
                  var type    = data.status === 1 ? 'success' : 'warning';
                  var message = data.status === 1 ?
                    Translator.trans('cms_shared_content.create.modal.success', { subSite: data.subSite }) :
                    Translator.trans('cms_shared_content.create.modal.warning', { subSite: data.subSite });

                  showToastrNotification(type, message)
                });
              },
              error: function(){
                showToastrNotification('error', Translator.trans('cms_shared_content.create.modal.error'))
              },
              complete: function() {
                ComitiumUtils.hideSpinner();
              }
            })
          }
        });

        modal.modal('show');
      },
      complete: function () {
        ComitiumUtils.hideSpinner();
      }
    });
  };

  return {
    init: function(contentId) {
      bindEvents(contentId);
    }
  };
})();
