//Layout-Code views
var CSTemplate;
var CSActions;
var CSWidgetQueue = new WidgetQueue();
var CSLayoutPageWidgets = null;

jQuery(function(){
	//var jq = jQuery.noConflict();
	var jq = jQuery;
	var breakpoints, breakpointKey;
	var iframeNode = jq('.csd-middle .site-wrapper iframe');

	iframeNode.data('loaded', false);
	iframeNode.ready(function(){

		jq.ajax({
			url: iframeNode.data('json'),
			dataType: "json",
			success: function(data){
				jq.ajax({
					url: iframeNode.data('get-widgets'),
					dataType: "json",
					success: function(widgetData) {
						data.layoutPageWidgets = widgetData.layoutPageWidgets;

						if(typeof data.layoutPageWidgets !== 'undefined') {
							CSLayoutPageWidgets = data.layoutPageWidgets;
						}

						CSTemplate = new Template(
							data.template,
							jq('.csd-top .buttons'),
							data.id
						);

						var iframeReady = setInterval(function () {
							if (iframeNode.contents().find("body").html() !== "") {
								onIframeReady();
								clearInterval(iframeReady);
							}
						}, 1000);

						function onIframeReady() {
							CSTemplate.render(
								iframeNode.contents().find(Template.SELECTOR)
							);
							jq('div', breakpoints).hide();
							jq(
								'a[data-value="'+breakpoints.data('default')+'"]',
								breakpoints
							).click();

							iframeNode.data('loaded', true);
							var Manager = new ContentManager(iframeNode);
							CSTemplate.setContentManager(Manager);
							CSTemplate.setMode(Template.CONTENT_MODE);
							Manager.enableContentMode();
						}
					}
				});
			}
		});


		jq('.csd-top .csd-options .csd-show-all').click(function(event) {
			event.preventDefault();
			jq('body', iframeNode.contents()).toggleClass('show_hidden');
			jq(this).toggleClass('active');
		});

		breakpoints = jq('.csd-bottom .responsive-views');
		if (breakpoints.length > 0) {
			jq('div span', breakpoints).click(function (event) {
				var node;

				event.preventDefault();

				if (!jq('.csd-bottom').data('locked')) {
					jq('div span.active', breakpoints).removeClass('active');
					jq(this).addClass('active');
					if (jq(this).data('width') > 0) {
						iframeNode.width(
							jq(this).data('width')
						);
						refreshIframe();
					}
				}
			});
			jq('a', breakpoints).click(function (event) {
				var sizes;

				event.preventDefault();

				if (!jq('.csd-bottom').data('locked') && !jq(this).hasClass('active')) {
					jq('a.active', breakpoints).removeClass('active');
					jq('div', breakpoints).fadeOut('fast');
					jq(this).addClass('active');
					CSTemplate.changeBreakpoint(jq(this).data('value'));
					sizes = jq(this).next(
						'div[data-breakpoint="'+jq(this).data('value')+'"]'
					);
					if (sizes.length > 0) {
						sizes.children().first().click();
						if (sizes.children() > 1) {
							sizes.fadeIn('fast');
						}
					}
				}
			});
		}

		//Widgets bar views
		jq('.csd-bottom .icon-group.widgets-views a').click(function (event) {
			event.preventDefault();

			if (!jq('.csd-bottom').data('locked')) {
				jq('.csd-bottom .icon-group.widgets-views a').removeClass('active');
				jq(this).addClass('active');
				jq('.csd-middle').removeClass('bar-left no-bar bar-right');
				jq('.csd-middle').addClass(jq(this).data('option'));
			}
		});
		jq('.csd-middle .widgets-wrapper .search form').submit(function () {
			var $this = jq(this);
			if (
				!$this.data('submitted') &&
				$this.serialize() != $this.data('search')
			) {
				$this.data('submitted', true);
				$this.data('search', $this.serialize());
				jq.ajax({
					'type': $this.prop('method'),
					'data': $this.serialize(),
					'url': $this.prop('action'),
					'complete': function (response) {
						var data, node, element;

						node = jq(
							'.csd-middle .widgets-wrapper .search .results.'
							+$this.data('type')
						);
						node.slideUp('fast').empty();
						if (response.status == 200) {
							data = jq.parseJSON(response.responseText);

							if (data) {
								jq.each(data, function(index, item){

									var _iClass = item.favorite ? 'fa-star' : 'fa-star-o';
									var _aText  = item.title||item.name;

									element = jq('<li/>', {
										'class': Template.DRAGGABLE_CLASS,
										'html': jq('<a/>', {
											'href': 'javascript: void(0);',
											'title': item.title === null ? item.name : item.title,
											'data-info': JSON.stringify(item),
											'html': '<i data-type="favorite" class="fa '+ _iClass +'"></i> ' + _aText
										})
									});

									element.addClass(ContentManager.TOOLBAR_DRAGGABLE_WIDGETS);
									element.attr('data-widget-id', item.id);
									node.append(element);

									CommonDesigner.init(element.find('[data-type="favorite"]'), true);
								});
								CSTemplate.getContentManager()
									.enableDraggableToolBar();
								node.slideDown();
							}
						}
						$this.data('submitted', false);
					}
				});
			}

			return false;
		});
	});

	function refreshIframe()
	{
		if (iframeNode.data('loaded')) {
			iframeNode.data('loaded', false);
			CSTemplate.getContentManager()
				.disableContentMode();
			CSTemplate.getContentManager()
				.enableContentMode();
			iframeNode.data('loaded', true);
		}
	}
});
