var Breakpoint = Class.extend({
	id: 0,
	name: '',
	minWidth: 0,
	maxWidth: 0,
	type: 0,

	init: function(data)
	{
		if (typeof(data) != "undefined") {
			this.load(data);
		}
	},
	load: function(data)
	{
		try {
			if (typeof(data) == "string") {
				data = jQuery.parseJSON(data);
			}
			this.id = data.id;
			this.name = data.name;
			this.minWidth = data.minWidth;
			this.maxWidth = data.maxWidth;
			this.type = data.type;
		} catch(error) {}
	},
	export: function()
	{
		return {
            id: this.id,
            name: this.name,
            minWidth: this.minWidth,
            maxWidth: this.maxWidth,
            type: this.type
        };
	}
});
Breakpoint.PREFIX_COLUMNS_CLASS = 'col';
Breakpoint.PREFIX_HIDDEN_CLASS = 'hidden';