var MultiWordsText = function() {
    var defaultOptions = {
        width: "100%",
        defaultText: "",
    };

    var resolveOptions = function (options) {
        return Object.assign(defaultOptions, options);
    };

    var bindElements = function (selector, options) {
        if (typeof selector === "string") {
            selector = $(selector);
        }

        selector.tagsInput(options);
    };

    return {
        handle: function(options, selector) {
            bindElements(
                typeof selector === "undefined" ? "[data-multiwords]" : selector,
                resolveOptions(options)
            );
        }
    };
}();
