CKEDITOR.plugins.add('csimage', {
    //requires: 'widget',

    init: function(editor) {
        delete editor._.menuItems.image;

        editor.csImage = CsAsset.init("image");

        editor
            .csImage
            .setAbsoluteUrlFromCKEditor(editor);

        var command = new CKEDITOR.command( editor, {
            exec: function( editor ) {

                _initEvents();

                var selectedElement = editor.getSelection().getSelectedElement();
                var image = _buildImage(selectedElement);

                editor.csImage.exec(image, function(element){
                    _createElement(element);
                });
            }
        } );

        var _createElement = function(element){
            var parent = getParent(editor.getSelection().getSelectedElement());

            if (parent) {
                parent.remove();
            }

            var e = editor.document.createElement( 'img');

            e.setAttribute('src', element.asset.src);
            e.setAttribute('title', element.asset.title ? element.asset.title: element.asset.src);
            e.setAttribute('alt', element.asset.title ? element.asset.title: element.asset.src);
            e.setAttribute('data-id', element.asset.id);
            e.setAttribute('data-resize', element.asset.resize);
            e.setAttribute('width', element.asset.width);
            e.setAttribute('height', element.asset.height);

            if (element.asset.html) {
                var html    = element.asset.html.replace("@asset@", e.getOuterHtml());
                var wrapper = editor.document.createElement(createElementFromHTML(html));

                editor.insertElement(wrapper);
            } else {
                editor.insertElement(e);
            }
        };

        var _initEvents = function() {

            editor.focusManager.lock();

            editor.csImage.signals.onDestroyModal.add(function(){
                editor.focusManager.unlock();
                editor.csImage.asset.id = "";
            });
        };

        var _buildImage = function(element) {

            var image  = editor.csImage.createAsset();

            if (!element || !element.is("img")) {
                return image;
            }

            var parent = getParent(element);

            if (parent) {
                image.html = parent.getOuterHtml().replace(/<img[^>]*>/, "@asset@");
            }

            if (element.getAttribute('src')) {
                image.src = element.getAttribute('src');
            }

            if (element.getAttribute('title')) {
                image.title = element.getAttribute('title');
            }

            if (element.getAttribute('width')) {
                image.width = element.getAttribute('width');
            }

            if (element.getAttribute('height')) {
                image.height = element.getAttribute('height');
            }

            if (element.getAttribute('data-id')) {
                image.id = element.getAttribute('data-id');
            } else {
                if (image.src ) {
                    var _src = image.src;
                    var pattern = new RegExp(/^\/uploads\/s[0-9]+\//);
                    if (pattern.test(_src) === true) {
                        var values = _src.split("/");
                        var id = "";
                        values.forEach(function(v){
                            pattern = new RegExp(/^\d+$/);
                            if (pattern.test(v) === true) {
                                id += v;
                            }
                        });

                        if (id != "") {
                            image.id = id;
                        }
                    }
                }
            }

            if (element.getAttribute('data-resize')) {
                image.resize = element.getAttribute('data-resize');
            }

            return image;
        };

        function createElementFromHTML(htmlString) {
            var div = document.createElement('div');

            div.innerHTML = htmlString.trim();

            return div.firstChild;
        }

        function getParent(element) {

            if (!element) {
                return null;
            }

            var parents = element.getParents(true);
            var parent = null;

            parents.forEach(function(p){
                if (p.hasAttribute("data-ck-asset-wrapper")) {
                    parent = p;
                    return false;
                }
            });

            return parent;
        }

        editor.addCommand('csimage', command);

        editor.ui.addButton( 'CsImage', {
            label: Translator.trans('cs_core.cs_image.label'),
            command: 'csimage',
            toolbar: 'image',
            icon: this.path + 'icons/csimage.png'
        });

        editor.keystrokeHandler.keystrokes[CKEDITOR.CTRL + 75] = 'csimage';

        editor.on('doubleclick', function( evt ) {
            var element = evt.data.element;

            if ( !element.isReadOnly() ) {
                if (element.is('img')) {

                    _initEvents();

                    evt.data.dialog = null;

                    var selectedElement = editor.getSelection().getSelectedElement();
                    var image = _buildImage(selectedElement);

                    editor.csImage.exec(image, function(element){
                        _createElement(element);
                    });
                }
            }
        },null,null,1);

    }

});
