<?php

namespace Comitium5\DesignerBundle\Repository\Layout;

use Comitium5\DesignerBundle\Model\Interfaces\SearchableRepositoryInterface;
use Comitium5\DesignerBundle\Repository\AbstractRepository;
use Doctrine\ORM\QueryBuilder;

/**
 * Class LayoutRepository
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Repository\Layout
 */
class LayoutRepository extends AbstractRepository implements SearchableRepositoryInterface
{
	/**
	 * @param string $term
	 * @param array $params optional
	 * @return QueryBuilder
	 */
	public function search($term, array $params = array())
	{
        $builder = $this->createQueryBuilder("l");

		$builder
			->andWhere("l.name LIKE :search")
			->setParameter("search", "%".$term."%");
		foreach ($params as $key => $value) {
			if (is_null($value)) {
				$builder->andWhere("l.".$key." IS NULL");
			} else {
				$builder
					->andWhere("l.".$key." = :".$key)
					->setParameter($key, $value);
			}
		}

		return $builder;
	}
}
