<?php

namespace Comitium5\DesignerBundle\Repository\Breakpoint;

use Comitium5\DesignerBundle\Model\Interfaces\SearchableRepositoryInterface;
use Comitium5\DesignerBundle\Repository\AbstractRepository;


/**
 * Class BreakpointRepository.
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 */
class BreakpointRepository extends AbstractRepository implements SearchableRepositoryInterface
{
    /**
     * @return \Doctrine\ORM\QueryBuilder
     */
    public function findAll()
    {
        return $this
            ->createQueryBuilder()
            ->addSelect('b')
            ->addOrderBy('b.createdAt', 'DESC')
            ->addOrderBy('b.id', 'DESC');
    }

    /**
     * @param $term
     * @param array $params
     *
     * @return mixed
     */
    public function search($term, array $params = array())
    {
        $builder = $this
            ->findAll();

        foreach (explode(' ', $term) as $key => $word) {
            $builder
                ->andWhere("CONCAT_WS('', b.name, b.type) LIKE ?$key")
                ->setParameter("$key", "%$word%");
        }

        return $builder;
    }
}
