<?php

namespace Comitium5\DesignerBundle\Provider;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\ApiClientBundle\Client\Services\SubsiteApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\DesignerBundle\Entity\Locale;
use Comitium5\DesignerBundle\Factory\NormalizerFactory;
use Comitium5\DesignerBundle\Factory\Subsite\SubsiteFactory;
use Comitium5\DesignerBundle\Model\Interfaces\Subsite\SubsiteInterface;
use Comitium5\DesignerBundle\Normalizer\Subsite\SubsiteNormalizer;
use Symfony\Component\PropertyAccess\PropertyAccessor;
use Comitium5\ApiClientBundle\Client\ClientInterface;

/**
 * Class SubsiteProvider
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Provider
 */
class SubsiteProvider
{
    /**
     * @var NormalizerFactory
     */
    private $normalizerFactory;

    /**
     * @var SubsiteInterface
     */
    private $subsite;

    /**
     * @var int
     */
    private $subsiteId;

    /**
     * SubsiteProvider constructor.
     *
     * @param ClientInterface $apiClient
     * @param $subsiteId
     */
    public function __construct(ClientInterface $apiClient, $subsiteId)
    {
        $this->subsiteId = $subsiteId;
        $this->subsite = null;
        $this->normalizerFactory = new NormalizerFactory(
            new SubsiteApiService($apiClient),
            new SubsiteFactory()
        );
    }

    /**
     * @return SubsiteInterface|mixed|null
     * @throws \Exception
     */
    public function getSubsite()
    {
        if ($this->subsite !== null) {
            return $this->subsite;
        }

        $this->subsite = $this
            ->normalizerFactory
            ->create(new IdentifiedValue($this->subsiteId));

        return $this->subsite;
    }

    /**
     * @return array|Locale[]
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getSubsiteLocales()
    {
        $subsite = $this->getSubsite();

        if (empty($subsite->getLocaleDomains())) {
            return [];
        }

        return $subsite->getLocaleDomains();
    }

    /**
     * @return Locale|null
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getDefaultLocaleDomain() {
        $locales = array_filter($this->getSubsiteLocales(), function (Locale $localeDomain) {
            return $localeDomain->isDefault() === true;
        });

        $locale = reset($locales);

        return empty($locale) ? null : $locale;
    }

    /**
     * @param $attribute
     * @param $value
     *
     * @return mixed|null
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getSubsiteLocaleFromAttr($attribute, $value)
    {
        $propertyAccessor = new PropertyAccessor();

        $locales = array_filter($this->getSubsiteLocales(), function (Locale $localeDomain) use ($attribute, $value, $propertyAccessor) {
            return $propertyAccessor->getValue($localeDomain, $attribute) === $value;
        });

        $locale = reset($locales);

        return empty($locale) ? null : $locale;
    }
}
