<?php

namespace Comitium5\DesignerBundle\Provider\Locale;

use Comitium5\DesignerBundle\Model\Interfaces\LocaleInterface;
use Comitium5\DesignerBundle\Provider\SubsiteProvider;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

/**
 * Class LocaleProvider
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Provider\Locale
 */
class LocaleProvider implements LocaleProviderInterface
{
    const SESSION_NAME = "_locale";
    const LOCALE_PARAM = "contentLocale";

    /**
     * @var SessionInterface
     */
    protected $session;

    /**
     * @var SubsiteProvider
     */
    protected $subSiteProvider;

    /**
     */
    protected $requestStack;

    /**
     * LocaleProvider constructor.
     * @param SessionInterface $session
     * @param SubSiteProvider $subSiteProvider
     * @param RequestStack $requestStack
     */
    public function __construct(
        SessionInterface $session,
        SubSiteProvider $subSiteProvider,
        RequestStack $requestStack
    ) {
        $this->session = $session;
        $this->subSiteProvider = $subSiteProvider;
        $this->requestStack = $requestStack;
    }

    /**
     * @return array
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getLocales()
    {
        return $this
            ->subSiteProvider
            ->getSubsiteLocales();
    }

    /**
     * @return LocaleInterface|null
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function getDefaultLocale()
    {
        $request = $this->requestStack->getMasterRequest();

        if ($request instanceof Request) {
            if ($request->query->has(self::LOCALE_PARAM)) {
                $locale = $this
                    ->subSiteProvider
                    ->getSubsiteLocaleFromAttr("code", $request->query->get(self::LOCALE_PARAM));

                if (!empty($locale)) {
                    return $locale;
                }
            }
        }

        if ($this->session->has(self::SESSION_NAME)) {
            $locale = \unserialize($this->session->get(self::SESSION_NAME));

            // Fix for break error after file changes @TODO fix
            if (!$locale instanceof \__PHP_Incomplete_Class) {
                return $this
                    ->subSiteProvider
                    ->getSubsiteLocaleFromAttr("id", $locale->getId());
            }
        }

        $locale = $this
            ->subSiteProvider
            ->getDefaultLocaleDomain();

        if ($locale === null) {
            throw new \Exception('Default locale domain must be defined');
        }

        return $locale;
    }

    /**
     * @param LocaleInterface $locale
     */
    public function setLocaleInSession(LocaleInterface $locale)
    {
        if ($this->session->has(self::SESSION_NAME)) {
            $this->session->remove(self::SESSION_NAME);
            $this->session->set(self::SESSION_NAME, serialize($locale));
        }
    }
}
