<?php

namespace Comitium5\DesignerBundle\Model\Traits\Page;


use Comitium5\DesignerBundle\Model\Interfaces\Page\PageInterface;

/**
 * Trait PageRelationTrait
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Page\PageInterface
 */
trait PageRelationTrait
{
    /**
     * @var PageInterface
     */
    protected $page;

    /**
     * @return PageInterface
     */
    public function getPage()
    {
        return $this->page;
    }

    /**
     * @param PageInterface|null $page
     *
     * @return $this
     */
    public function setPage(PageInterface $page = null)
    {
        $this->page = $page;

        return $this;
    }
}
