<?php

namespace Comitium5\DesignerBundle\Model\Traits;

use Comitium5\DesignerBundle\Model\Interfaces\HierarchicalInterface;
use Doctrine\Common\Collections\Collection;

/**
 * Trait HierarchicalTrait
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits
 */
trait HierarchicalTrait
{
    /**
     * @var Collection $children
     */
    protected $children;

    /**
     * @var object|null $parent
     */
    protected $parent;

    /**
     * @param $child
     *
     * @return $this|HierarchicalInterface
     */
    public function addChild($child): HierarchicalInterface
    {
        if (!$this->children->contains($child)) {
            $this->children->add($child);
        }

        return $this;
    }

    /**
     * @param $child
     *
     * @return $this|HierarchicalInterface
     */
    public function removeChild($child): HierarchicalInterface
    {
        $this->children->removeElement($child);

        return $this;
    }

    /**
     * @return Collection
     */
    public function getChildren(): Collection
    {
        return $this->children;
    }

    /**
     * @param object|null $parent
     *
     * @return $this|HierarchicalInterface
     */
    public function setParent(object $parent = null): HierarchicalInterface
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * @return object|null
     */
    public function getParent(): ?object
    {
        return $this->parent;
    }
}
