<?php

namespace Comitium5\DesignerBundle\Model\Traits;

use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;

/**
 * Trait DateTimeFactoryTrait
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits
 */
trait DateTimeFactoryTrait
{
    /**
     * @param DateTimeInterface $entity
     * @param $serializeEntity
     *
     * @return $this
     */
    public function setDateTime(DateTimeInterface $entity, $serializeEntity)
    {
        $dateFormat = "Y-m-d H:i:s";

        $creationDate = \DateTime::createFromFormat($dateFormat, $serializeEntity["creationDate"]);

        if ($creationDate !== false) {
            $entity->setCreatedAt($creationDate);
        }

        $modificationDate = \DateTime::createFromFormat($dateFormat, $serializeEntity["creationDate"]);

        if ($modificationDate !== false) {
            $entity->setCreatedAt($modificationDate);
        }

        return $this;
    }
}
