<?php

namespace Comitium5\DesignerBundle\Model\Traits\Css;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

/**
 * Trait CssRelationTrait
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits
 */
trait CssCollectionTrait
{
    /**
     * @var Collection
     */
    protected $css;

    /**
     * @param $css
     *
     * @return self
     */
    public function addCss($css)
    {
        return $this;
    }

    /**
     * @param $css
     *
     * @return self
     */
    public function removeCss($css)
    {
        return $this;
    }

    /**
     * @return Collection
     */
    public function getCss()
    {
        return new ArrayCollection();
    }

    /**
     * @param Collection $css
     *
     * @return self
     */
    public function setCss(Collection $css)
    {
        $this->css = $css;

        return $this;
    }
}
