<?php

namespace Comitium5\DesignerBundle\Model\Traits\Breakpoint;


use Comitium5\DesignerBundle\Model\Interfaces\Breakpoint\BreakpointInterface;
use Doctrine\Common\Collections\Collection;

/**
 * Trait BreakpointCollectionTrait
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits
 */
trait BreakpointCollectionTrait
{
    /**
     * @var Collection
     */
    protected $breakpoints;

    /**
     * @param BreakpointInterface $breakpoint
     * @return self
     */
    public function addBreakpoint(BreakpointInterface $breakpoint)
    {
		if (!$this->breakpoints->contains($breakpoint)) {
			$this->breakpoints->add($breakpoint);
		}

        return $this;
    }

    /**
     * @param BreakpointInterface $breakpoint
     * @return self
     */
    public function removeBreakpoint(BreakpointInterface $breakpoint)
    {
        $this->breakpoints->removeElement($breakpoint);
        return $this;
    }

    /**
     * @return Collection
     */
    public function getBreakpoints()
    {
        return $this->breakpoints;
    }

    /**
     * @param Collection $breakpoints
     * @return self
     */
    public function setBreakpoints(Collection $breakpoints)
    {
        $this->breakpoints = $breakpoints;
        return $this;
    }
}
