<?php

namespace Comitium5\DesignerBundle\Model;

/**
 * Class PageType
 * @desc Defines different pages
 * @package Comitium5\DesignerBundle\Model
 */
class PageType
{
    /**
     * @desc Defines a standard page
     * @type Number
     */
    const CMS_STANDARD_PAGE = 100;

    /**
     * @desc Defines a news viewer page
     * @type Number
     */
    const CMS_NEWS_VIEWER = 101;

    /**
     * @desc Defines a poll viewer page
     * @type Number
     */
    const CMS_POLL_VIEWER = 103;

    /**
     * @desc Defines a calendar viewer page
     * @type Number
     */
//    const CMS_CALENDAR_VIEWER = 104;

    /**
     * @desc Defines a event viewer page
     * @type Number
     */
    const CMS_EVENT_VIEWER = 105;

    /**
     * @desc Defines a event viewer page
     * @type Number
     */
    const CMS_CLASSIFIED_VIEWER = 107;

    /**
     * @desc Defines a event viewer page
     * @type Number
     */
    const CMS_AUTHOR_VIEWER = 108;

    /**
     * @desc Defines a event viewer page
     * @type Number
     */
    const CMS_GALLERY_VIEWER = 109;

    /**
     * @desc Defines a live events viewer page
     * @type Number
     */
    const CMS_LIVE_EVENT_VIEWER = 110;

    /**
     * @desc Defines a live events viewer page
     * @type Number
     */
    const CMS_DIRECTORY_ITEM = 111;

    /**
     * @desc Defines a contest viewer page
     * @type Number
     */
    const CMS_CONTEST_VIEWER = 112;

    /**
     * @desc Defines a unsubscribe mailing page
     * @type Number
     */
    const CMS_UNSUBSCRIBE_MAILING = 113;

    /**
     * @desc Defines a categories viewer page
     * @type Number
     */
    const ADMIN_PAGE = 200;

    /**
     * @desc Defines an 404 error page
     * @type Number
     */
    const ERROR_404 = 400;

    /**
     * @desc Defines an 500 error page
     * @type Number
     */
    const ERROR_500 = 401;

    /**
     * @desc Defines an AMP page
     * @type Number
     */
    const AMP_PAGE = 500;
}
