<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\View;

use Doctrine\Common\Collections\Collection;

/**
 * Interface ViewCollectionInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\View
 */
interface ViewCollectionInterface
{
    /**
     * @return Collection
     */
    public function getViews();

    /**
     * @param Collection $views
     *
     * @return $this
     */
    public function setViews(Collection $views);

    /**
     * @param ViewInterface $view
     *
     * @return $this
     */
    public function addView(ViewInterface $view);

    /**
     * @param ViewInterface $view
     *
     * @return $this
     */
    public function removeView(ViewInterface $view);
}
