<?php

namespace Comitium5\DesignerBundle\Model\Interfaces;

/**
 * Interface SerializeInterface
 * 
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces
 */
interface SerializeInterface
{
    /**
     * @param  array  $allowedFields (optional)
     * @param  array  $deniedFields  (optional)
     * @param  array  $entityFields  (optional)
     * @return array
     */
    public function toArray($allowedFields = array(), $deniedFields = array(), $entityFields = array());

    /**
     * @param  array  $data (optional)
     * @return self
     */
    public function fromArray(array $data);

    /**
     * @param  \ReflectionMethod $method
     * @return boolean
     */
    public function isGetMethod(\ReflectionMethod $method);

    /**
     * @param  \ReflectionMethod $method
     * @return boolean
     */
    public function isSetMethod(\ReflectionMethod $method);

    /**
     * @return string (JSON)
     */
    public function toJSON();

    /**
     * @param string $json (JSON)
     * @return self
     */
    public function fromJSON(string $json);
}
