<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Layout;

use Comitium5\DesignerBundle\Model\Interfaces\SortableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\TmpIdentifierInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Widget\WidgetRelationInterface;

/**
 * Interface LayoutPageWidgetInterface
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Layout
 */
interface LayoutPageWidgetInterface extends
    SortableInterface,
    LayoutPageRelationInterface,
    WidgetRelationInterface,
    TmpIdentifierInterface
{
    /**
     * @return \DateTime
     */
    public function getStartAt();

    /**
     * @param \DateTime $startAt
     * @return self
     */
    public function setStartAt(\DateTime $startAt);

    /**
     * @return \DateTime
     */
    public function getEndAt();

    /**
     * @param \DateTime $endAt
     * @return self
     */
    public function setEndAt(\DateTime $endAt);

    /**
     * @param array $parameters
     *
     * @return mixed
     */
    public function setParameters(array $parameters);

    /**
     * @return array
     */
    public function getParameters();
}
