<?php

namespace Comitium5\DesignerBundle\Model\Interfaces;

use Doctrine\Common\Collections\Collection;

/**
 * Interface HierarchicalInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces
 */
interface HierarchicalInterface
{
    /**
     * @param $child
     *
     * @return HierarchicalInterface
     */
    public function addChild($child): HierarchicalInterface;

    /**
     * @param $child
     *
     * @return HierarchicalInterface
     */
    public function removeChild($child): HierarchicalInterface;

    /**
     * @return Collection
     */
    public function getChildren(): Collection;

    /**
     * @param object|null $parent
     *
     * @return HierarchicalInterface
     */
    public function setParent(object $parent = null): HierarchicalInterface;

    /**
     * @return object|null
     */
    public function getParent(): ?object;
}
