<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Css;


use Comitium5\DesignerBundle\Model\Interfaces\Code\BackupCodeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Code\CodeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\SelfContentTypeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\SortableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\TmpIdentifierInterface;

/**
 * Interface CssInterface
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Css
 */
interface CssInterface extends
    DateTimeInterface,
    SelfContentTypeInterface,
    SortableInterface,
    CodeInterface,
    BackupCodeInterface,
    TmpIdentifierInterface
{
    /**
     * @return string
     */
    public function getName();

    /**
     * @param string $name
     * @return self
     */
    public function setName(string $name);

    /**
     * @param $preCompiledCode
     * @return mixed
     */
    public function setPreCompiledCode($preCompiledCode);

    /**
     * @return mixed
     */
    public function getPreCompiledCode();
}
