<?php

namespace Comitium5\DesignerBundle\Model;

/**
 * Class self
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\DesignerBundle\Model
 */
final class ContentType
{
    const PAGES = 101;
    const ARTICLE = 102;
    const ACTIVITY = 103;
    const POLL = 104;
    const FAQ = 105;
    const GLOSSARIES = 106;
    const DIRECTORIES = 107;
    const CLASSIFIEDS = 108;
    const ASSET_IMAGES = 109;
    const ASSET_VIDEOS = 110;
    const ASSET_SOUNDS = 111;
    const ASSET_DOCUMENTS = 112;
    const GALLERIES = 113;
    const AUTHOR = 115;
    const ASSETS = 116;
    const DIRECTORIES_ITEMS = 117;
    const CATEGORY = 118;
    const TAG = 119;
    const DIARY = 120;
    const CONTACTS = 121;
    const COMMENTS = 122;
    const WIDGETS  = 123;
    const CSS  = 124;
    const LIBRARIES  = 125;
    const LIVE_EVENT  = 126;
    const CONTEST  = 127;
    const AGENCY_ARTICLE = 128;
    const AGENCY_ASSET_IMAGES = 129;
    const AGENCY_ASSET_VIDEOS = 130;
    const AGENCY_ASSET_SOUNDS = 131;
    const ORDER = 132;

    /**
     * @param $name
     * @return integer|null
     */
    public static function getConstant($name)
    {
        $value = null;

        $name = strtoupper($name);

        if (defined('self::'.$name)) {
            $value = constant('self::'.$name);
        }

        return $value;
    }

    /**
     * @return array
     */
    public static function getArrayForChoiceForm()
    {
        return array_flip([
            self::PAGES => "cs_content_type.types.pages",
            self::ARTICLE => "cs_content_type.types.article",
            self::ACTIVITY => "cs_content_type.types.activity",
            self::POLL => "cs_content_type.types.poll",
//            self::FAQ => "cs_content_type.types.faq",
//            self::GLOSSARIES => "cs_content_type.types.glossaries",
            self::DIRECTORIES => "cs_content_type.types.directories",
            self::DIRECTORIES_ITEMS => "cs_content_type.types.directories_items",
            self::CLASSIFIEDS => "cs_content_type.types.classifieds",
            self::ASSET_IMAGES => "cs_content_type.types.asset_images",
            self::ASSET_VIDEOS => "cs_content_type.types.asset_videos",
            self::ASSET_SOUNDS => "cs_content_type.types.asset_sounds",
            self::ASSET_DOCUMENTS => "cs_content_type.types.asset_documents",
            self::GALLERIES => "cs_content_type.types.galleries",
            self::LIVE_EVENT => "cs_content_type.types.live_event",
            self::CONTEST => "cs_content_type.types.contest",
            self::AUTHOR => "cs_content_type.types.author",
        ]);
    }
}
