<?php

namespace Comitium5\DesignerBundle\Form\Type\Suggest;

use Comitium5\ApiClientBundle\Client\ClientInterface;
use Comitium5\DesignerBundle\Form\DataTransformer\MultipleSubSiteSuggestDataTransformer;
use Comitium5\DesignerBundle\Provider\Subsite\MultipleSubsiteProvider;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\Router;
use Symfony\Component\Routing\RouterInterface;

/**
 * Class MultipleSubSiteSuggestType
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\Form\Type\Suggest
 */
class MultipleSubSiteSuggestType extends AbstractType
{
    /**
     * @var ClientInterface
     */
    protected $apiService;

    /**
     * @var MultipleSubsiteProvider
     */
    protected $multipleSubsiteProvider;

    /**
     * @var RouterInterface
     */
    protected $router;

    /**
     * MultipleSubSiteSuggestType constructor.
     *
     * @param ClientInterface $apiService
     * @param MultipleSubsiteProvider $multipleSubsiteProvider
     * @param RouterInterface $router
     */
    public function __construct(
        ClientInterface $apiService,
        MultipleSubsiteProvider $multipleSubsiteProvider,
        RouterInterface $router
    ) {
        $this->apiService = $apiService;
        $this->multipleSubsiteProvider = $multipleSubsiteProvider;
        $this->router = $router;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $transformer = new MultipleSubSiteSuggestDataTransformer($this->apiService);

        $builder
            ->addViewTransformer(
                $transformer
                    ->setProperty($options['property'])
                    ->setMultiple($options['multiple'])
                    ->setLabelProperties($options['labelProperties'])
                    ->setSeparator($options['separator'])
                    ->setContentType($options['content_type'])
            );
    }

    /**
     * @param FormView $view
     * @param FormInterface $form
     * @param array $options
     *
     * @throws \Exception
     */
    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        $view->vars['url'] = $this
            ->router
            ->generate(
                $options['route'],
                [],
                Router::ABSOLUTE_URL
            );

        $subSites = $options["subsites"];

        if (empty($subSites)) {
            $allSubsites = $this
                ->multipleSubsiteProvider
                ->getSubsites();

            foreach ($allSubsites as $subSite) {
                $subSites[$subSite->getName()] = $subSite->getAcronym();
            }
        }

        $view->vars['subsites'] = $subSites;
        $view->vars['property'] = $options['property'];
        $view->vars['allow_clear'] = $options['allow_clear'];
        $view->vars['id'] = $options['id'];
        $view->vars['limit'] = $options['limit'];
        $view->vars['multiple'] = $options['multiple'];
        $view->vars['dropdownCssClass'] = $options['dropdownCssClass'];
        $view->vars['autoInitialize'] = $options['autoInitialize'];
        $view->vars['findByProperties'] = $options['findByProperties'];
        $view->vars['labelProperties'] = $options['labelProperties'];
        $view->vars['onlyPublished'] = intval($options['onlyPublished']);
        $view->vars['isMultipleSubsiteSuggest'] = intval($options['isMultipleSubsiteSuggest']);
        $view->vars['content_type'] = $options['content_type'];
        $view->vars['separator'] = $options['separator'];
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setRequired([
                'route',
                'property',
                'subsites',
                'content_type',
            ])
            ->setDefined([
                'allow_create',
                'allow_clear',
                'multiple',
                'limit',
                'dropdownCssClass',
                'autoInitialize',
                'findByProperties',
                'labelProperties',
                'onlyPublished',
                'isMultipleSubsiteSuggest',
                'data_class',
            ])
            ->setDefaults([
                'route'                    => 'designer_multiple_suggest',
                'property'                 => 'title',
                'allow_create'             => false,
                'allow_clear'              => 1,
                'id'                       => null,
                'multiple'                 => false,
                'limit'                    => 10,
                'autoInitialize'           => "true",
                'dropdownCssClass'         => "",
                'findByProperties'         => null,
                'labelProperties'          => null,
                'onlyPublished'            => false,
                'subsites'                 => [],
                'isMultipleSubsiteSuggest' => true,
                'content_type'             => null,
                'separator'                => '|',
                'data_class'               => null,
            ]);
    }

    /**
     * @return string
     */
    public function getParent(): string
    {
        return TextType::class;
    }

    /**
     * @return string
     */
    public function getBlockPrefix(): string
    {
        return 'multiple_subsite_suggest';
    }
}
